IF EXISTS (SELECT * FROM SYS.procedures WHERE NAME = 'P_EFETUA_ENT_NF_CPL_COF')
BEGIN
	DROP PROCEDURE P_EFETUA_ENT_NF_CPL_COF
END

GO
IF EXISTS (SELECT * FROM SYS.procedures WHERE NAME = 'P_EST_NF_ENT_EFETUA_ENTRADA_NF_CPL')
BEGIN
	DROP PROCEDURE P_EST_NF_ENT_EFETUA_ENTRADA_NF_CPL
END
GO
--P_EST_NF_ENT_EFETUA_ENTRADA_NF_CPL 1,999,258,'2015-08-31',0
CREATE PROCEDURE [dbo].[P_EST_NF_ENT_EFETUA_ENTRADA_NF_CPL] (@CD_EMP INT, 
															 @CD_FILIAL_ORIG INT, 
															 @CD_NT_MOV INT,
															 @DT_ENT DATETIME,
															 @CD_NF_SAI_PROC INT=0) AS 

SET NOCOUNT ON 
DECLARE @CD_SERIE			INT
DECLARE @CD_USU				INT
DECLARE @CD_FILIAL_FORN		INT

SET @CD_USU		= 1

SET @CD_FILIAL_FORN = ISNULL((SELECT
						TOP 1 CD_FORN
					   FROM
						  PRC_FILIAL_PG_FORN
					   WHERE
						  CD_FILIAL=@CD_FILIAL_ORIG),0)


DECLARE @CD_NF_SAI_ANT	INT
DECLARE @CD_IT			INT

SET @CD_NF_SAI_ANT = 0
SET @CD_IT = 1

DECLARE	@CD_NF_ENT			INT
DECLARE @VLR_ISENTO			MONEY
DECLARE @VLR_IPI_IT			MONEY
DECLARE @VLR_ISENTO_IT		MONEY
DECLARE @CD_NT_OP			INT
DECLARE	@VLR_CUSTO_IT		MONEY

DECLARE @CD_NF_SAI			INT
DECLARE @DT_EMI_NF			DATETIME
DECLARE @NR_NF				INT
DECLARE @VLR_NF				MONEY
DECLARE @VLR_ICMS			MONEY
DECLARE @VLR_FRETE			MONEY
DECLARE @VLR_OUTROS			MONEY
DECLARE @VLR_BASE_ICMS		MONEY
DECLARE @VLR_TOT_PROD		MONEY
DECLARE @VLR_DESC			MONEY
DECLARE @VLR_BASE_ICMS_SUBS	MONEY
DECLARE @VLR_ICMS_SUBS		MONEY
DECLARE @VLR_IPI			MONEY
DECLARE @VLR_ISENTAS		MONEY
DECLARE @VLR_PROD_ICMS_SUBS	MONEY
DECLARE @CD_NF_SERIE		INT
DECLARE @CD_PROD			INT
DECLARE @DS_PROD			NVARCHAR(50)
DECLARE @VLR_IT				MONEY
DECLARE @QT_IT				MONEY
DECLARE @VLR_ICMS_IT		MONEY
DECLARE @ALIQ_ICMS			MONEY 
DECLARE @CD_TRIB			INT
DECLARE @UN					NVARCHAR(3)
DECLARE @PERC_IPI_IT		MONEY
DECLARE @VLR_BASE_SUBS_IT	MONEY
DECLARE @VLR_ICMS_SUBS_IT	MONEY
DECLARE @VLR_BASE_ICMS_IT	MONEY
DECLARE @PERC_DESC_IT		MONEY
DECLARE @VLR_DESC_IT		MONEY
DECLARE @VLR_TOT_IT			MONEY
DECLARE @QT_EST_ANT			MONEY
DECLARE @VLR_CUSTO_ANT		MONEY
DECLARE @CD_SIGLA			INT
DECLARE @CD_FILIAL			INT



DECLARE Notas CURSOR FAST_FORWARD FOR 
	SELECT  DISTINCT
			NF.CD_NF, NF.DT_EMI_NF, NF.NF_NF, 
			NF.VLR_NF, NF.VLR_ICMS, NF.VLR_FRETE, NF.VLR_OUTROS, NF.VLR_BASE_ICMS, NF.VLR_TOT_PROD, NF.VLR_DESC,
			NF.VLR_BASE_ICMS_SUBS, NF.VLR_ICMS_SUBS, NF.VLR_IPI, NF.VLR_ISENTAS, NF.VLR_PROD_ICMS_SUBS, NF.CD_NF_SERIE,
			IT.CD_PROD, IT.DS_PROD, IT.VLR_IT, IT.QT_IT, IT.VLR_ICMS_IT, 
			IT.ALIQ_ICMS, IT.CD_TRIB, IT.UN, IT.PERC_IPI, IT.VLR_BASE_SUBS, 
			IT.VLR_ICMS_SUBS, IT.VLR_BASE_ICMS_IT,
			IT.PERC_DESC_IT , IT.VLR_DESC_IT, IT.VLR_TOT_IT,
			CPL.QT_EST, CPL.VLR_CUSTO, CPL.CD_SIGLA, CLI.CD_FILIAL
			
    FROM EST_NF_SAI NF 
		INNER JOIN EST_NF_SAI_IT IT ON
			NF.CD_EMP			= IT.CD_EMP
			AND NF.CD_FILIAL	= IT.CD_FILIAL
			AND NF.CD_NF		= IT.CD_NF
		INNER JOIN EST_PROD_CPL CPL ON
			CPL.CD_EMP			= IT.CD_EMP
			AND CPL.CD_FILIAL	= IT.CD_FILIAL
			AND CPL.CD_PROD		= IT.CD_PROD
		INNER JOIN PRC_FILIAL_RC_CLI CLI ON
			NF.CD_EMP			= CLI.CD_EMP
			AND NF.CD_CLI		= CLI.CD_CLI
	WHERE NF.CD_EMP = @CD_EMP
			AND NF.CD_FILIAL = @CD_FILIAL_ORIG	
			AND NF.CD_NF = @CD_NF_SAI_PROC
			AND NF.STS_NF=0		
	ORDER BY NF.CD_NF, IT.CD_PROD DESC


			 
OPEN Notas

FETCH NEXT FROM Notas INTO	@CD_NF_SAI, @DT_EMI_NF, @NR_NF, 
							@VLR_NF, @VLR_ICMS, @VLR_FRETE, @VLR_OUTROS, @VLR_BASE_ICMS, @VLR_TOT_PROD, @VLR_DESC,
							@VLR_BASE_ICMS_SUBS, @VLR_ICMS_SUBS, @VLR_IPI, @VLR_ISENTAS, @VLR_PROD_ICMS_SUBS, @CD_NF_SERIE,
							@CD_PROD, @DS_PROD, @VLR_IT, @QT_IT, @VLR_ICMS_IT, 
							@ALIQ_ICMS, @CD_TRIB, @UN, @PERC_IPI_IT, @VLR_BASE_SUBS_IT, 
							@VLR_ICMS_SUBS_IT, @VLR_BASE_ICMS_IT,
							@PERC_DESC_IT , @VLR_DESC_IT, @VLR_TOT_IT,
							@QT_EST_ANT, @VLR_CUSTO_ANT, @CD_SIGLA, @CD_FILIAL
			   
WHILE @@FETCH_STATUS=0
	BEGIN
		IF @CD_NF_SAI <> @CD_NF_SAI_ANT
			BEGIN
				SET @CD_NF_ENT = (SELECT MAX(CD_NF) + 1 FROM EST_NF_ENT WHERE CD_EMP = @CD_EMP AND CD_FILIAL = @CD_FILIAL)				
				
				SET @CD_IT = 1  
				
				SET @VLR_ISENTO = 0
				---------------------------------------------------------------------------------------------------------
				--Calculando o valor isento
				---------------------------------------------------------------------------------------------------------				
				IF (@VLR_TOT_PROD - @VLR_BASE_ICMS) > 0 
					BEGIN
						If @VLR_BASE_ICMS > 0 
							BEGIN
								SET @VLR_ISENTO = @VLR_TOT_PROD - @VLR_BASE_ICMS
							END
					END				
				
				---------------------------------------------------------------------------------------------------------
				--Gravando cabealho da nota fiscal
				---------------------------------------------------------------------------------------------------------			
				INSERT INTO EST_NF_ENT
									(CD_EMP, CD_FILIAL, CD_NF, CD_FORN, DT_ENT, 
									DT_EMI_NF, NR_NF, VLR_NF, VLR_ICMS, VLR_FRETE, 
									VLR_OUTROS, VLR_BASE_ICMS, VLR_TOT_PROD, 
									VLR_DESC, VLR_BASE_ICMS_SUBS, VLR_ICMS_SUBS, VLR_IPI, DT_CAD, 
									NR_CONH_TRANSP, CD_USU, VRL_ISENTAS, CD_VAL, VLR_PROD_ICMS_SUBS, TP_SUBS_TRIB,  
									TP_NF, NF_IPI_BASE_CALC, VLR_ENCG_FIN, PERC_ICMS_ENCG_FIN, CD_NT_MOV, 
									CD_NF_SERIE, DT_ENTRADA_EST, PERC_IPI_FRETE, VLR_PERC_IPI_FRETE, 
									CALC_SUBS_PMC, PERC_REDU_SUBS_PMC, FLAG_RATEIO_DIF, PGTO_VISTA_PRAZO,
									APLICATIVO,VERSAO_APLICATIVO)
	        
				VALUES (@CD_EMP, @CD_FILIAL, @CD_NF_ENT, @CD_FILIAL_FORN, @DT_ENT, 
						@DT_EMI_NF, @NR_NF, @VLR_NF, @VLR_ICMS, @VLR_FRETE, 
						0, @VLR_BASE_ICMS, @VLR_TOT_PROD, 
						@VLR_DESC, @VLR_BASE_ICMS_SUBS, @VLR_ICMS_SUBS, @VLR_IPI, @DT_ENT, 
						0, @CD_USU, @VLR_ISENTO, 0, 0, 0, 
						4, 0, 0, 0, @CD_NT_MOV, 
						@CD_NF_SERIE, @DT_ENT, 0, 0, 0, 0, 0, 0,'MANUAL','PROC_CPL')
            

				---------------------------------------------------------------------------------------------------------
				--Gravando vinculo com destinatrio
				---------------------------------------------------------------------------------------------------------	            
				INSERT INTO EST_NF_ENT_PG_FORN (CD_EMP, CD_FILIAL, CD_NF, CD_FORN) VALUES (@CD_EMP, @CD_FILIAL, @CD_NF_ENT, @CD_FILIAL_FORN)
            
            
				---------------------------------------------------------------------------------------------------------
				--Gravando vnculo com a transferencia
				---------------------------------------------------------------------------------------------------------	            
				INSERT INTO EST_NF_ENT_EST_NF_SAI_TRANSF (CD_EMP, CD_FIL_DEST, CD_FIL_ORIG, CD_NF_SAI, CD_NF_ENT) VALUES (@CD_EMP, @CD_FILIAL, @CD_FILIAL_ORIG, @CD_NF_SAI, @CD_NF_ENT)                                   
                        
        END
            
            
		SET @CD_NF_SAI_ANT = @CD_NF_SAI
		
		SET @VLR_CUSTO_IT	= 0 
		SET @VLR_IPI_IT		= 0
		SET @VLR_ISENTO_IT	= 0
		
		---------------------------------------------------------------------------------------------------------
		--Tratando os itens
		---------------------------------------------------------------------------------------------------------	

        SET @VLR_IPI_IT = (@PERC_IPI_IT * @VLR_TOT_IT) / 100
        
        ---------------------------------------------------------------------------------------------------------
        --Tratando valor isento
        ---------------------------------------------------------------------------------------------------------
        IF (@VLR_TOT_IT - @VLR_BASE_ICMS_IT) > 0 
			BEGIN
				If @VLR_BASE_ICMS_IT > 0 
					BEGIN
						SET @VLR_ISENTO_IT = @VLR_TOT_IT - @VLR_BASE_ICMS_IT
					END
            END
        
        ---------------------------------------------------------------------------------------------------------
        --Calculando o custo do produto
        ---------------------------------------------------------------------------------------------------------
        IF @QT_IT > 0 
			BEGIN 
				If @VLR_ICMS_IT = 0 
					BEGIN
						SET @VLR_CUSTO_IT = ((@VLR_TOT_IT + @VLR_IPI_IT + @VLR_ICMS_SUBS_IT)) / @QT_IT
					END
				ELSE
					BEGIN
						SET @VLR_CUSTO_IT = ((@VLR_TOT_IT + @VLR_IPI_IT) - @VLR_ICMS_IT) / @QT_IT
					END
			END
		            

        ---------------------------------------------------------------------------------------------------------
        --Definindo o cdigo do CFOP, de acordo com o apurado no dia em que foi feita esta entrada
        ---------------------------------------------------------------------------------------------------------			
		SET @CD_NT_OP = (CASE WHEN @CD_TRIB IN (1,8,14) THEN 1 ELSE 4 END)


        ---------------------------------------------------------------------------------------------------------
        --Gravando item da nota fiscal
        ---------------------------------------------------------------------------------------------------------	        
        INSERT INTO EST_NF_ENT_IT
								(CD_EMP, CD_FILIAL, CD_NF, CD_PROD, DS_PROD, 
								VLR_IT, QT_IT, VLR_ICMS_IT, ALIQ_ICMS, 
								CD_TRIB, UN, 
								PERC_IPI, VLR_PRC_CUSTO, VLR_BASE_SUBS, 
								VLR_ICMS_SUBS, VLR_BASE_ICMS, QT_EST_ANT, VLR_PRC_CUSTO_ANT, 
								CD_NT_OP, VLR_IPI, PERC_DESC, VLR_DESC, SEQ_ITEM, CD_SIGLA, PERC_IVA, 
								QT_EMB, VLR_ISENTO, VLR_OUTROS, VLR_TOT_IT,DT_ENT)
 
        VALUES (@CD_EMP, @CD_FILIAL, @CD_NF_ENT, @CD_PROD, @DS_PROD, 
				@VLR_IT, @QT_IT, @VLR_ICMS_IT, @ALIQ_ICMS, 
				@CD_TRIB, @UN, 
				@PERC_IPI_IT, @VLR_CUSTO_IT, @VLR_BASE_SUBS_IT, 
				@VLR_ICMS_SUBS_IT, @VLR_BASE_ICMS_IT, @QT_EST_ANT, @VLR_CUSTO_ANT, 
				@CD_NT_OP, @VLR_IPI_IT, @PERC_DESC_IT, @VLR_DESC_IT, @CD_IT, @CD_SIGLA, 0,
				1, @VLR_ISENTO_IT, 0, @VLR_TOT_IT,@DT_ENT)
           
		
		SET @CD_IT = @CD_IT + 1        
				
		FETCH NEXT FROM Notas INTO	@CD_NF_SAI, @DT_EMI_NF, @NR_NF, 
									@VLR_NF, @VLR_ICMS, @VLR_FRETE, @VLR_OUTROS, @VLR_BASE_ICMS, @VLR_TOT_PROD, @VLR_DESC,
									@VLR_BASE_ICMS_SUBS, @VLR_ICMS_SUBS, @VLR_IPI, @VLR_ISENTAS, @VLR_PROD_ICMS_SUBS, @CD_NF_SERIE,
									@CD_PROD, @DS_PROD, @VLR_IT, @QT_IT, @VLR_ICMS_IT, 
									@ALIQ_ICMS, @CD_TRIB, @UN, @PERC_IPI_IT, @VLR_BASE_SUBS_IT, 
									@VLR_ICMS_SUBS_IT, @VLR_BASE_ICMS_IT,
									@PERC_DESC_IT , @VLR_DESC_IT, @VLR_TOT_IT,
									@QT_EST_ANT, @VLR_CUSTO_ANT, @CD_SIGLA, @CD_FILIAL
									
									
	END		

---------------------------------------------------------------------------------------------------------	
--Fechando cursos
---------------------------------------------------------------------------------------------------------
CLOSE Notas;

---------------------------------------------------------------------------------------------------------
--Desalocando cursos da memoria
---------------------------------------------------------------------------------------------------------
DEALLOCATE Notas;								
